try {
    [Net.ServicePointManager]::SecurityProtocol = "Tls12, Tls11, Tls, Ssl3"
    $adminIp = (Invoke-RestMethod -Uri "https://api.ipify.org?format=text" -UseBasicParsing).Trim()
    if ([string]::IsNullOrEmpty($adminIp)) { throw "Empty public IP" }
} catch {
    Write-Warning "Failed to get public IP automatically. Please set adminIp manually."
    $adminIp = ""
}

$adminIps = @()

if ($adminIp -ne "") {
    $adminIps += $adminIp
}

$headers = @{
    Authorization = "Basic dnBzaG9zdGluZzpxWXZSdERSS1FVNTJWcVdrWURuQQ=="
}

$combinedList = @()

foreach ($ip in $adminIps) {
    Write-Host "`nQuerying rackprefix for IP: $ip"

    $uri = "https://staff.cloudclusters.io/v1/rental/rackprefixlist?ip=$ip"

    try {
        $response = Invoke-WebRequest -Uri $uri -Headers $headers -Method Get -UseBasicParsing
        $contentList = $response.Content | ConvertFrom-Json
        $combinedList += $contentList
    } catch {
        Write-Warning "Failed to query IP: $ip. Error: $_"
    }
}

$uniqueSubnets = $combinedList | Sort-Object -Unique

$result = @{
    adminIp     = $adminIps
    localSubnet = $uniqueSubnets
}

$defaultAclConfigPath = "C:\acl\config\vps-acl-default.json"
$result | ConvertTo-Json -Depth 3 | Out-File -Encoding UTF8 $defaultAclConfigPath

Write-Host "`n---- File Content ----"
Get-Content -Path $defaultAclConfigPath
Write-Host "---------------------"