# txt file path
$txtPath = "C:\software\abnormal_vps_detect\packages.txt"

# Get local hostname as Hosting Server name
$hostname = $env:COMPUTERNAME
Write-Host "Local hostname detected: $hostname"

# Import txt as CSV (tab delimiter)
$data = Import-Csv -Path $txtPath -Delimiter "`t"

# Filter by Hosting Server (ignore case)
$vpsList = $data | Where-Object { $_.'Hosting_Server' -ieq $hostname }

# Check if empty
if (-not $vpsList) {
    Write-Host "New panel cannot find this hosting server, it may be an old panel server."
    exit
}

# Get VPS Names in txt list (ignore case)
$vpsNameList = $vpsList.'Vps_Name'

# Process VPS from txt
foreach ($vps in $vpsList) {
    $vpsName = $vps.'Vps_Name'
    $vpsIP = $vps.'Ip'

    # Find VM in Hyper-V (ignore case)
    $vm = Get-VM | Where-Object { $_.Name -ieq $vpsName }

    if ($vm) {
        if ($vm.State -eq "Running") {
            $ping = Test-Connection -ComputerName $vpsIP -Count 2 -Quiet

            if (-not $ping) {
                Write-Host "VPS Name: $vpsName"
                Write-Host "VPS IP: $vpsIP"
                Write-Host "Hyper-V State: $($vm.State)"
                Write-Host "Ping Result: Unreachable"
                Write-Host "----------------------------------------"
            }
            # Else: Running & ping success  ӡ
        }
        else {
            # Not Running
            Write-Host "VPS Name: $vpsName"
            Write-Host "VPS IP: $vpsIP"
            Write-Host "Hyper-V State: $($vm.State)"
            Write-Host "Note: Not running."
            Write-Host "----------------------------------------"
        }
    }
    else {
        # VM not found
        Write-Host "VPS Name: $vpsName"
        Write-Host "VPS IP: $vpsIP"
        Write-Host "Hyper-V State: Not Found"
        Write-Host "Note: Not running."
        Write-Host "----------------------------------------"
    }
}

# Process Hyper-V VMs that are not in txt
$allVMs = Get-VM | Where-Object { $_.State -eq "Running" }

foreach ($vm in $allVMs) {
    $vmName = $vm.Name

    # Check if in txt list (ignore case)
    $found = $vpsNameList -contains $vmName

    if (-not ($vpsNameList -contains $vmName)) {
        Write-Host "VPS Name: $vmName"
        Write-Host "VPS IP: Unknown"
        Write-Host "Hyper-V State: Running"
        Write-Host "Note: Running but not found in packages.txt"
        Write-Host "----------------------------------------"
    }
}
