<?xml version="1.0" encoding="utf-8" ?>
<!-- *******************************************************************
Copyright (c) Microsoft Corporation.  All rights reserved.
******************************************************************** -->

<Configuration>


  <SelectionSets>
    <SelectionSet>
      <Name>RegisteredServerTypes</Name>
      <Types>
        <TypeName>Microsoft.SqlServer.Management.RegisteredServers.ServerGroup</TypeName>
        <TypeName>Microsoft.SqlServer.Management.RegisteredServers.RegisteredServer</TypeName>
      </Types>
    </SelectionSet>
  </SelectionSets>

  <!-- ################ GLOBAL CONTROL DEFINITIONS ################ -->
  <Controls>
    <Control>
      <Name>RegisteredServerTypes-GroupingFormat</Name>
      <CustomControl>
        <CustomEntries>
          <CustomEntry>
            <CustomItem>
              <Frame>
                <LeftIndent>4</LeftIndent>
                <CustomItem>
                  <Text>Directory: </Text>
                  <ExpressionBinding>
                    <ScriptBlock>$_.PSParentPath</ScriptBlock>
                  </ExpressionBinding>
                  <NewLine/>
                </CustomItem>
              </Frame>
            </CustomItem>
          </CustomEntry>
        </CustomEntries>
      </CustomControl>
    </Control>
  </Controls>



  <ViewDefinitions>

    <!-- SMO -->

    <View>
      <Name>Server</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Server</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>80</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

	  <View>
		  <Name>Database</Name>
		  <ViewSelectedBy>
			  <TypeName>Microsoft.SqlServer.Management.Smo.Database</TypeName>
		  </ViewSelectedBy>
		  <TableControl>
			  <TableHeaders>

				  <TableColumnHeader>
					  <Label>Name</Label>
					  <Width>20</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Status</Label>
					  <Width>15</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Containment Type</Label>
					  <Width>16</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Recovery Model</Label>
					  <Width>14</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>CompatLvl</Label>
					  <Width>9</Width>
					  <Alignment>right</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Collation</Label>
					  <Width>30</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Owner</Label>
					  <Width>25</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

			  </TableHeaders>
			  <TableRowEntries>
				  <TableRowEntry>
					  <Wrap/>
					  <TableColumnItems>

						  <TableColumnItem>
							  <PropertyName>Name</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>Status</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>ContainmentType</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>RecoveryModel</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <ScriptBlock>
								  [int] $_.CompatibilityLevel
							  </ScriptBlock>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>Collation</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>Owner</PropertyName>
						  </TableColumnItem>

					  </TableColumnItems>
				  </TableRowEntry>
			  </TableRowEntries>
		  </TableControl>
	  </View>

    <View>
      <Name>Table</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Table</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>View</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.View</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>StoredProcedure</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.StoredProcedure</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>User</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.User</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Login</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Login</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Login</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Login</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>45</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Login Type</Label>
            <Width>13</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>LoginType</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ServerRole</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.ServerRole</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Fixed Role</Label>
            <Width>11</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Owner</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Modified</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsFixedRole</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.DateCreated.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Owner</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.DateModified.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>Sequence</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Sequence</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>CurrentValue</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        
          <TableColumnHeader>
            <Label>IsExhausted</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Owner</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Modified</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>


              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>CurrentValue</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsExhausted</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Owner</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.DateLastModified.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
<!--end sequence-->

    <View>
      <Name>Schema</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Schema</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Owner</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Owner</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Index</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Index</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>80</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Trigger</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Trigger</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>UserDefinedFunction</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.UserDefinedFunction</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>SystemMessage</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.SystemMessage</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Language</Label>
            <Width>15</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Text</Label>
            <Width>58</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Language</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Text</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>UserDefinedMessage</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.UserDefinedMessage</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Language</Label>
            <Width>15</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Text</Label>
            <Width>58</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Language</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Text</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <!-- DMF -->

    <View>
      <Name>PolicyStore</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.PolicyStore</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>80</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Policy</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.Policy</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Category</Label>
            <Width>17</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Enabled</Label>
            <Width>7</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PolicyCategory</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Enabled</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>EvaluationHistory</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.EvaluationHistory</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Policy Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Result</Label>
            <Width>6</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Start Date</Label>
            <Width>18</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>End Date</Label>
            <Width>18</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Messages</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>
              
              <TableColumnItem>
                <PropertyName>PolicyName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Result</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.StartDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.EndDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Exception</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ConnectionEvaluationHistory</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.ConnectionEvaluationHistory</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Server Instance</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Result</Label>
            <Width>6</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Messages</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>ServerInstance</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Result</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Exception</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    
    <View>
      <Name>EvaluationDetail</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.EvaluationDetail</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Result</Label>
            <Width>6</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Query Expression</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Messages</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Result</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetQueryExpression</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>Exception</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TargetSet</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.TargetSet</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Type Skeleton</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Enabled</Label>
            <Width>5</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetType</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetTypeSkeleton</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Enabled</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    
    <View>
      <Name>TargetSetLevel</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.TargetSetLevel</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Condition</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Type Skeleton</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Level Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Condition</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetTypeSkeleton</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>LevelName</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>Condition</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.Condition</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Facet</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Facet</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>PolicyCategory</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.PolicyCategory</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Mandate Database Subscriptions</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>MandateDatabaseSubscriptions</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>PolicyCategorySubscription</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.PolicyCategorySubscription</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Policy Category</Label>
            <Width>23</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target</Label>
            <Width>23</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Type</Label>
            <Width>23</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PolicyCategory</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Target</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetType</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>ObjectSet</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.ObjectSet</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Facet</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Facet</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <!-- SQL Server Registrations -->

    <View>
      <Name>children</Name>
      <ViewSelectedBy>
        <SelectionSetName>RegisteredServerTypes</SelectionSetName>
      </ViewSelectedBy>
      <GroupBy>
        <PropertyName>PSParentPath</PropertyName>
        <CustomControlName>RegisteredServerTypes-GroupingFormat</CustomControlName>
      </GroupBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Mode</Label>
            <Width>4</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Mode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    <View>
      <Name>children</Name>
      <ViewSelectedBy>
        <SelectionSetName>RegisteredServerTypes</SelectionSetName>
      </ViewSelectedBy>
      <GroupBy>
        <PropertyName>PSParentPath</PropertyName>
        <CustomControlName>RegisteredServerTypes-GroupingFormat</CustomControlName>
      </GroupBy>
      <ListControl>
        <ListEntries>
          <ListEntry>
            <EntrySelectedBy>
              <TypeName>Microsoft.SqlServer.Management.RegisteredServers.ServerGroup</TypeName>
            </EntrySelectedBy>
            <ListItems>
              <ListItem>
                <PropertyName>DisplayName</PropertyName>
              </ListItem>
            </ListItems>
          </ListEntry>
          <ListEntry>
            <ListItems>
              <ListItem>
                <PropertyName>DisplayName</PropertyName>
              </ListItem>
            </ListItems>
          </ListEntry>
        </ListEntries>
      </ListControl>
    </View>

    <!-- Data Collector -->


   <View>
      <Name>CollectionSet</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Collector.CollectionSet</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>IsRunning</Label>
            <Width>10</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>36</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsRunning</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

   <View>
      <Name>CollectionItem</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Collector.CollectionItem</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Collector Type</Label>
            <Width>27</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Collection Frequency</Label>
            <Width>21</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>CollectionFrequency</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <!-- SQL Server Provider Types -->

    <View>
      <Name>SqlServerProviderExtension</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.PowerShell.Extensions.SqlServerProviderExtension</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>15</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Root</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Root</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Machine</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.PowerShell.Extensions.Machine</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>MachineName</Label>
            <Width>32</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>MachineName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>CollectionInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Sdk.Sfc.CollectionInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>60</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <!-- Extended Events -->
    <View>
      <Name>XEStore</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.XEStore</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Total Session Count</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Running Session Count</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.Sessions.Count</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>RunningSessionCount</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Session</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Session</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>AutoStartUp</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>IsRunning</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Start Time</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>AutoStart</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsRunning</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.StartTime.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Event</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Event</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Package Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Predicate</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PackageName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PredicateExpression</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Target</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Target</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Package Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PackageName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>EventField</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.EventField</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TargetField</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.TargetField</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
    <View>
      <Name>Action</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Action</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Package Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PackageName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
    <View>
      <Name>Package</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Package</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


          <TableColumnHeader>
            <Label>Module ID</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>
             
              <TableColumnItem>
                <PropertyName>ModuleID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>EventInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.EventInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Capabilities</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>CapabilitiesDesc</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>EventColumnInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.EventColumnInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DataEventColumnInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.DataEventColumnInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ReadOnlyEventColumnInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.ReadOnlyEventColumnInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ActionInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.ActionInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Action Name</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TargetInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.TargetInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TargetColumnInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.TargetColumnInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>


              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TypeInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.TypeInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Type Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type Size</Label>
            <Width>10</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Size</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MapInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.MapInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MapValueInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.MapValueInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
    <View>
      <Name>PredSourceInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.PredSourceInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>PredCompareInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.PredCompareInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <!-- Utility -->
    <View>
      <Name>Utility</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.Utility</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>80</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

   <View>
      <Name>Computer</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.Computer</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Clustered</Label>
            <Width>27</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsClustered</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Volume</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.Volume</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Mount Point</Label>
            <Width>12</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Space Utilization %</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Total Space</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Total Space Used</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>MountPointLocation</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TotalSpaceUtilization</PropertyName>
              </TableColumnItem>
              
              <TableColumnItem>
                <PropertyName>TotalSpace</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TotalSpaceUsed</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Processor</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.Processor</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Processor Name</Label>
            <Width>16</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Architecture</Label>
            <Width>18</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Clock Speed</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Architecture</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>ClockSpeed</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
    <View>
      <Name>ImportedObject</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.ImportedObject</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Version</Label>
            <Width>27</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Version</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

  <!-- DAC -->

  <View>
      <Name>DAC</Name>
      <ViewSelectedBy>
          <TypeName>Microsoft.SqlServer.Management.DAC.DacStore</TypeName>
      </ViewSelectedBy>
      <TableControl>
          <TableHeaders>

              <TableColumnHeader>
                  <Label>Name</Label>
                  <Width>80</Width>
                  <Alignment>left</Alignment>
              </TableColumnHeader>

          </TableHeaders>
          <TableRowEntries>
              <TableRowEntry>
                  <TableColumnItems>

                      <TableColumnItem>
                          <PropertyName>Name</PropertyName>
                      </TableColumnItem>

                  </TableColumnItems>
              </TableRowEntry>
          </TableRowEntries>
      </TableControl>
  </View>
  <View>
    <Name>DacPackage</Name>
    <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.DAC.DacInstance</TypeName>
    </ViewSelectedBy>
    <TableControl>
        <TableHeaders>

            <TableColumnHeader>
                <Label>Instance Name</Label>
                <Width>30</Width>
                <Alignment>left</Alignment>
            </TableColumnHeader>

            <TableColumnHeader>
                <Label>Application Name</Label>
                <Width>30</Width>
                <Alignment>left</Alignment>
            </TableColumnHeader>

            <TableColumnHeader>
                <Label>Application Version</Label>
                <Width>27</Width>
                <Alignment>left</Alignment>
            </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
            <TableRowEntry>
                <TableColumnItems>

                    <TableColumnItem>
                        <PropertyName>Name</PropertyName>
                    </TableColumnItem>

                    <TableColumnItem>
                        <ScriptBlock>$_.Type.Name</ScriptBlock>
                    </TableColumnItem>

                    <TableColumnItem>
                        <ScriptBlock>$_.Type.Version</ScriptBlock>
                    </TableColumnItem>

                </TableColumnItems>
            </TableRowEntry>
        </TableRowEntries>
    </TableControl>
  </View>

  <!-- AlwaysOn -->
  <View>
    <Name>AvailabilityDatabase</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityDatabase</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>Name</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>SynchronizationState</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>IsSuspended</Label>
          <Width>11</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>IsJoined</Label>
          <Width>8</Width>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>SynchronizationState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>IsSuspended</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <ScriptBlock>$_.IsJoined -eq 1</ScriptBlock>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>AvailabilityGroup</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityGroup</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>Name</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>PrimaryReplicaServerName</Label>
          <Width>32</Width>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>PrimaryReplicaServerName</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>AvailabilityReplica</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityReplica</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>Name</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Role</Label>
          <Width>9</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>ConnectionState</Label>
          <Width>15</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>RollupSynchronizationState</Label>
          <Width>26</Width>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Role</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>ConnectionState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>RollupSynchronizationState</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>DatabaseReplicaState</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.Smo.DatabaseReplicaState</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>AvailabilityReplicaServerName</Label>
          <Width>29</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>AvailabilityDatabaseName</Label>
          <Width>24</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>SynchronizationState</Label>
          <Width>21</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>EstimatedRecoveryTime</Label>
          <Width>24</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>SynchronizationPerformance</Label>
          <Width>26</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>LogSendQueueSize</Label>
          <Width>16</Width>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>AvailabilityReplicaServerName</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>AvailabilityDatabaseName</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>SynchronizationState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>EstimatedRecoveryTime</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>SynchronizationPerformance</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>LogSendQueueSize</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>DatabaseReplicaHealthState</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.PowerShell.Hadr.DatabaseReplicaHealthState</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>HealthState</Label>
          <Width>22</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>AvailabilityGroup</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>AvailabilityReplica</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Name</Label>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>HealthState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>AvailabilityGroup</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>AvailabilityReplica</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>AvailabilityReplicaHealthState</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.PowerShell.Hadr.AvailabilityReplicaHealthState</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>HealthState</Label>
          <Width>22</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>AvailabilityGroup</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Name</Label>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>HealthState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>AvailabilityGroup</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>AvailabilityGroupHealthState</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.PowerShell.Hadr.AvailabilityGroupHealthState</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>HealthState</Label>
          <Width>22</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Name</Label>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
              <TableColumnItem>
                <PropertyName>HealthState</PropertyName>           
              </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>PolicyEvaluationDetails</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.PowerShell.PolicyEvaluationDetails</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>Result</Label>
          <Width>6</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>TargetObject</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Category</Label>
          <Width>35</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Name</Label>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>Result</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>TargetObject</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Category</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

    <View>
      <Name>AvailabilityGroupListener</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityGroupListener</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>PortNumber</Label>
            <Width>15</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>ClusterIPConfiguration</Label>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <wrap />
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>PortNumber</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ClusterIPConfiguration</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>AvailabilityGroupListenerIPAddress</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityGroupListenerIPAddress</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>IsDhcp</Label>
            <Width>6</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>SubnetMask</Label>
            <Width>20</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>IPAddress</Label>
            <Width>40</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>IsDHCP</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>SubnetMask</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>IPAddress</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>IPAddressState</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
  <!-- Analysis Services Provider - SQLAS -->

    <View>
      <Name>AnalysisServerHost</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.PowerShell.Provider.AnalysisServerHost</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Host Name</Label>
            <Width>80</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MajorObjectCollection</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MajorObjectCollection</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Collections</Label>
            <Width>80</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ASServer</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Server</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>80</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <!-- DisplayName may not be available when servers are retrieved using AnalysisServerHost.AnalysisServers property -->
                <ScriptBlock>
                  if ([string]::IsNullOrEmpty($_.DisplayName)) { $_.Name }
                  else { $_.DisplayName }
                </ScriptBlock>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ASDatabase</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Database</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read-Write Mode</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ReadWriteMode</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Cube</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Cube</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Processing Mode</Label>
            <Width>16</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Last Processed On</Label>
            <Width>17</Width>
            <Alignment>Right</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ProcessingMode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <ScriptBlock>$_.LastProcessed.ToString("g")</ScriptBlock>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MeasureGroup</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MeasureGroup</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Type</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Processing Mode</Label>
            <Width>16</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Type</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ProcessingMode</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>AggregateDesign</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.AggregationDesign</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>60</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Estimated Rows</Label>
            <Width>20</Width>
            <Alignment>Right</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>EstimatedRows</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Partition</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Partition</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Aggregation Design ID</Label>
            <Width>21</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Estimated Rows</Label>
            <Width>14</Width>
            <Alignment>Right</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Processing Mode</Label>
            <Width>16</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Type</Label>
            <Width>10</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Storage Mode</Label>
            <Width>12</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>AggregationDesignID</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>EstimatedRows</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ProcessingMode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Type</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>CurrentStorageMode</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Dimension</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Dimension</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>35</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Processing Mode</Label>
            <Width>16</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Current Storage Mode</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ProcessingMode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>CurrentStorageMode</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DimensionPermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DimensionPermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Assembly</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Assembly</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>60</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Loaded State</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>IsLoaded</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DatabasePermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DatabasePermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Role</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Role</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>60</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Created On</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <ScriptBlock>$_.CreatedTimeStamp.ToSTring("g")</ScriptBlock>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MiningStructure</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MiningStructure</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Collation</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Cache Mode</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Collation</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>CacheMode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MiningModel</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MiningModel</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Algorithm</Label>
            <Width>28</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>AllowDrillThrough</Label>
            <Width>17</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Algorithm</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>AllowDrillThrough</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MiningModelPermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MiningModelPermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MiningStructurePermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MiningStructurePermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Trace</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Trace</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Log File Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Log File Size</Label>
            <Width>13</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Auto Restart</Label>
            <Width>12</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>LogFileName</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>LogFileSize</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>AutoRestart</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MdxScript</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MdxScript</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Default Script</Label>
            <Width>17</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Created Timestamp</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>DefaultScript</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <ScriptBlock>$_.CreatedTimestamp.ToSTring("g")</ScriptBlock>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Perspective</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Perspective</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>KPIs</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Dimensions</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>MeasureGroups</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Kpis</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Dimensions</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>MeasureGroups</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>CubePermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.CubePermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DataSource</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DataSource</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Isolation</Label>
            <Width>13</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Max Connections</Label>
            <Width>15</Width>
            <Alignment>Right</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Connection String</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Isolation</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>MaxActiveConnections</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ConnectionString</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DataSourcePermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DataSourcePermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DataSourceView</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DataSourceView</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Primary Data Source</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>DataSource</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

      <!-- Tabular 1200 View -->

      <!-- Tabular 1200 Database -->
      <View>
          <Name>ASDatabase</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.Tabular.Database</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Name</Label>
                      <Width>40</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>State</Label>
                      <Width>20</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Read-Write Mode</Label>
                      <Width>20</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>Name</PropertyName>
                          </TableColumnItem>
                          <TableColumnItem>
                              <PropertyName>State</PropertyName>
                          </TableColumnItem>
                          <TableColumnItem>
                              <PropertyName>ReadWriteMode</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

      <!-- Tabular 1200 Model -->
      <View>
          <Name>Model</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.Tabular.Model</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Name</Label>
                      <Width>10</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Default Mode</Label>
                      <Width>16</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Default DataView</Label>
                      <Width>16</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Structure Modified On</Label>
                      <Width>30</Width>
                      <Alignment>Right</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>Name</PropertyName>
                          </TableColumnItem>
                          <TableColumnItem>
                              <PropertyName>DefaultMode</PropertyName>
                          </TableColumnItem>
                          <TableColumnItem>
                              <PropertyName>DefaultDataView</PropertyName>
                          </TableColumnItem>
                          <TableColumnItem>
                              <ScriptBlock>$_.StructureModifiedTime.ToString("g")</ScriptBlock>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

      <!-- TabularCollection -->
      <View>
          <Name>TabularCollection</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.PowerShell.Provider.TabularCollection</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Navigable Items</Label>
                      <Width>25</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>DisplayName</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

      <!-- Tabular 1200 DataSource -->
      <View>
          <Name>DataSource</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.Tabular.DataSource</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Data Source Name</Label>
                      <Width>35</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>ConnectionString</Label>
                      <Width>60</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>Name</PropertyName>
                          </TableColumnItem>
                          <TableColumnItem>
                              <PropertyName>ConnectionString</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

      <!-- Tabular 1200 Table -->
      <View>
          <Name>Table</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.Tabular.Table</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Name</Label>
                      <Width>35</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Partitions</Label>
                      <Width>10</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>Name</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                      <TableColumnItems>
                          <TableColumnItem>
                              <ScriptBlock>$_.Partitions.Count</ScriptBlock>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

      <!-- Tabular 1200 Role -->
      <View>
          <Name>ModelRole</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.Tabular.ModelRole</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Name</Label>
                      <Width>35</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Members</Label>
                      <Width>10</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>Name</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                      <TableColumnItems>
                          <TableColumnItem>
                              <ScriptBlock>$_.Members.Count</ScriptBlock>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

      <!-- Tabular 1200 Role Membership -->
      <View>
          <Name>WindowsModelRoleMember</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.Tabular.WindowsModelRoleMember</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Name</Label>
                      <Width>30</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Member ID</Label>
                      <Width>50</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>MemberName</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>MemberID</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

      <!-- Tabular 1200 Column -->
      <View>
          <Name>Column</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.Tabular.Column</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Name</Label>
                      <Width>35</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Data Type</Label>
                      <Width>10</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>Name</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>DataType</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

      <!-- Tabular 1200 Measure -->
      <View>
          <Name>Measure</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.Tabular.Measure</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Name</Label>
                      <Width>35</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Data Type</Label>
                      <Width>10</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>Name</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>DataType</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

      <!-- Tabular 1200 Measure -->
      <View>
          <Name>Partition</Name>
          <ViewSelectedBy>
              <TypeName>Microsoft.AnalysisServices.Tabular.Partition</TypeName>
          </ViewSelectedBy>
          <TableControl>
              <TableHeaders>
                  <TableColumnHeader>
                      <Label>Name</Label>
                      <Width>35</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>State</Label>
                      <Width>20</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
                  <TableColumnHeader>
                      <Label>Mode</Label>
                      <Width>20</Width>
                      <Alignment>Left</Alignment>
                  </TableColumnHeader>
              </TableHeaders>
              <TableRowEntries>
                  <TableRowEntry>
                      <TableColumnItems>
                          <TableColumnItem>
                              <PropertyName>Name</PropertyName>
                          </TableColumnItem>
                          <TableColumnItem>
                              <PropertyName>State</PropertyName>
                          </TableColumnItem>
                          <TableColumnItem>
                              <PropertyName>Mode</PropertyName>
                          </TableColumnItem>
                      </TableColumnItems>
                  </TableRowEntry>
              </TableRowEntries>
          </TableControl>
      </View>

  </ViewDefinitions>
</Configuration>

<!-- SIG # Begin signature block -->
<!-- MIIkEAYJKoZIhvcNAQcCoIIkATCCI/0CAQExDzANBglghkgBZQMEAgEFADB5Bgor -->
<!-- BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG -->
<!-- KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCB8+z0SbLbulkAW -->
<!-- l97s4zuc1l5aZNfgIEFUBjVdm5rusaCCDZIwggYQMIID+KADAgECAhMzAAAAZEeE -->
<!-- lIbbQRk4AAAAAABkMA0GCSqGSIb3DQEBCwUAMH4xCzAJBgNVBAYTAlVTMRMwEQYD -->
<!-- VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy -->
<!-- b3NvZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29mdCBDb2RlIFNpZ25p -->
<!-- bmcgUENBIDIwMTEwHhcNMTUxMDI4MjAzMTQ2WhcNMTcwMTI4MjAzMTQ2WjCBgzEL -->
<!-- MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v -->
<!-- bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9Q -->
<!-- UjEeMBwGA1UEAxMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMIIBIjANBgkqhkiG9w0B -->
<!-- AQEFAAOCAQ8AMIIBCgKCAQEAky7a2OY+mNkbD2RfTahYTRQ793qE/DwRMTrvicJK -->
<!-- LUGlSF3dEp7vq2YoNNV9KlV7TE2K8sDxstNSFYu2swi4i1AL3X/7agmg3GcExPHf -->
<!-- vHUYIEC+eCyZVt3u9S7dPkL5Wh8wrgEUirCCtVGg4m1l/vcYCo0wbU06p8XzNi3u -->
<!-- XyygkgCxHEziy/f/JCV/14/A3ZduzrIXtsccRKckyn6B5uYxuRbZXT7RaO6+zUjQ -->
<!-- hiyu3A4hwcCKw+4bk1kT9sY7gHIYiFP7q78wPqB3vVKIv3rY6LCTraEbjNR+phBQ -->
<!-- EL7hyBxk+ocu+8RHZhbAhHs2r1+6hURsAg8t4LAOG6I+JQIDAQABo4IBfzCCAXsw -->
<!-- HwYDVR0lBBgwFgYIKwYBBQUHAwMGCisGAQQBgjdMCAEwHQYDVR0OBBYEFFhWcQTw -->
<!-- vbsz9YNozOeARvdXr9IiMFEGA1UdEQRKMEikRjBEMQ0wCwYDVQQLEwRNT1BSMTMw -->
<!-- MQYDVQQFEyozMTY0Mis0OWU4YzNmMy0yMzU5LTQ3ZjYtYTNiZS02YzhjNDc1MWM0 -->
<!-- YjYwHwYDVR0jBBgwFoAUSG5k5VAF04KqFzc3IrVtqMp1ApUwVAYDVR0fBE0wSzBJ -->
<!-- oEegRYZDaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9jcmwvTWljQ29k -->
<!-- U2lnUENBMjAxMV8yMDExLTA3LTA4LmNybDBhBggrBgEFBQcBAQRVMFMwUQYIKwYB -->
<!-- BQUHMAKGRWh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMvY2VydHMvTWlj -->
<!-- Q29kU2lnUENBMjAxMV8yMDExLTA3LTA4LmNydDAMBgNVHRMBAf8EAjAAMA0GCSqG -->
<!-- SIb3DQEBCwUAA4ICAQCI4gxkQx3dXK6MO4UktZ1A1r1mrFtXNdn06DrARZkQTdu0 -->
<!-- kOTLdlGBCfCzk0309RLkvUgnFKpvLddrg9TGp3n80yUbRsp2AogyrlBU+gP5ggHF -->
<!-- i7NjGEpj5bH+FDsMw9PygLg8JelgsvBVudw1SgUt625nY7w1vrwk+cDd58TvAyJQ -->
<!-- FAW1zJ+0ySgB9lu2vwg0NKetOyL7dxe3KoRLaztUcqXoYW5CkI+Mv3m8HOeqlhyf -->
<!-- FTYxPB5YXyQJPKQJYh8zC9b90JXLT7raM7mQ94ygDuFmlaiZ+QSUR3XVupdEngrm -->
<!-- ZgUB5jX13M+Pl2Vv7PPFU3xlo3Uhj1wtupNC81epoxGhJ0tRuLdEajD/dCZ0xIni -->
<!-- esRXCKSC4HCL3BMnSwVXtIoj/QFymFYwD5+sAZuvRSgkKyD1rDA7MPcEI2i/Bh5O -->
<!-- MAo9App4sR0Gp049oSkXNhvRi/au7QG6NJBTSBbNBGJG8Qp+5QThKoQUk8mj0ugr -->
<!-- 4yWRsA9JTbmqVw7u9suB5OKYBMUN4hL/yI+aFVsE/KJInvnxSzXJ1YHka45ADYMK -->
<!-- AMl+fLdIqm3nx6rIN0RkoDAbvTAAXGehUCsIod049A1T3IJyUJXt3OsTd3WabhIB -->
<!-- XICYfxMg10naaWcyUePgW3+VwP0XLKu4O1+8ZeGyaDSi33GnzmmyYacX3BTqMDCC -->
<!-- B3owggVioAMCAQICCmEOkNIAAAAAAAMwDQYJKoZIhvcNAQELBQAwgYgxCzAJBgNV -->
<!-- BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4w -->
<!-- HAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xMjAwBgNVBAMTKU1pY3Jvc29m -->
<!-- dCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAyMDExMB4XDTExMDcwODIwNTkw -->
<!-- OVoXDTI2MDcwODIxMDkwOVowfjELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp -->
<!-- bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw -->
<!-- b3JhdGlvbjEoMCYGA1UEAxMfTWljcm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EgMjAx -->
<!-- MTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAKvw+nIQHC6t2G6qghBN -->
<!-- NLrytlghn0IbKmvpWlCquAY4GgRJun/DDB7dN2vGEtgL8DjCmQawyDnVARQxQtOJ -->
<!-- DXlkh36UYCRsr55JnOloXtLfm1OyCizDr9mpK656Ca/XllnKYBoF6WZ26DJSJhIv -->
<!-- 56sIUM+zRLdd2MQuA3WraPPLbfM6XKEW9Ea64DhkrG5kNXimoGMPLdNAk/jj3gcN -->
<!-- 1Vx5pUkp5w2+oBN3vpQ97/vjK1oQH01WKKJ6cuASOrdJXtjt7UORg9l7snuGG9k+ -->
<!-- sYxd6IlPhBryoS9Z5JA7La4zWMW3Pv4y07MDPbGyr5I4ftKdgCz1TlaRITUlwzlu -->
<!-- ZH9TupwPrRkjhMv0ugOGjfdf8NBSv4yUh7zAIXQlXxgotswnKDglmDlKNs98sZKu -->
<!-- HCOnqWbsYR9q4ShJnV+I4iVd0yFLPlLEtVc/JAPw0XpbL9Uj43BdD1FGd7P4AOG8 -->
<!-- rAKCX9vAFbO9G9RVS+c5oQ/pI0m8GLhEfEXkwcNyeuBy5yTfv0aZxe/CHFfbg43s -->
<!-- TUkwp6uO3+xbn6/83bBm4sGXgXvt1u1L50kppxMopqd9Z4DmimJ4X7IvhNdXnFy/ -->
<!-- dygo8e1twyiPLI9AN0/B4YVEicQJTMXUpUMvdJX3bvh4IFgsE11glZo+TzOE2rCI -->
<!-- F96eTvSWsLxGoGyY0uDWiIwLAgMBAAGjggHtMIIB6TAQBgkrBgEEAYI3FQEEAwIB -->
<!-- ADAdBgNVHQ4EFgQUSG5k5VAF04KqFzc3IrVtqMp1ApUwGQYJKwYBBAGCNxQCBAwe -->
<!-- CgBTAHUAYgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0j -->
<!-- BBgwFoAUci06AjGQQ7kUBU7h6qfHMdEjiTQwWgYDVR0fBFMwUTBPoE2gS4ZJaHR0 -->
<!-- cDovL2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljUm9vQ2Vy -->
<!-- QXV0MjAxMV8yMDExXzAzXzIyLmNybDBeBggrBgEFBQcBAQRSMFAwTgYIKwYBBQUH -->
<!-- MAKGQmh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2Vy -->
<!-- QXV0MjAxMV8yMDExXzAzXzIyLmNydDCBnwYDVR0gBIGXMIGUMIGRBgkrBgEEAYI3 -->
<!-- LgMwgYMwPwYIKwYBBQUHAgEWM2h0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lv -->
<!-- cHMvZG9jcy9wcmltYXJ5Y3BzLmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUAZwBh -->
<!-- AGwAXwBwAG8AbABpAGMAeQBfAHMAdABhAHQAZQBtAGUAbgB0AC4gHTANBgkqhkiG -->
<!-- 9w0BAQsFAAOCAgEAZ/KGpZjgVHkaLtPYdGcimwuWEeFjkplCln3SeQyQwWVfLiw+ -->
<!-- +MNy0W2D/r4/6ArKO79HqaPzadtjvyI1pZddZYSQfYtGUFXYDJJ80hpLHPM8QotS -->
<!-- 0LD9a+M+By4pm+Y9G6XUtR13lDni6WTJRD14eiPzE32mkHSDjfTLJgJGKsKKELuk -->
<!-- qQUMm+1o+mgulaAqPyprWEljHwlpblqYluSD9MCP80Yr3vw70L01724lruWvJ+3Q -->
<!-- 3fMOr5kol5hNDj0L8giJ1h/DMhji8MUtzluetEk5CsYKwsatruWy2dsViFFFWDgy -->
<!-- cScaf7H0J/jeLDogaZiyWYlobm+nt3TDQAUGpgEqKD6CPxNNZgvAs0314Y9/HG8V -->
<!-- fUWnduVAKmWjw11SYobDHWM2l4bf2vP48hahmifhzaWX0O5dY0HjWwechz4GdwbR -->
<!-- BrF1HxS+YWG18NzGGwS+30HHDiju3mUv7Jf2oVyW2ADWoUa9WfOXpQlLSBCZgB/Q -->
<!-- ACnFsZulP0V3HjXG0qKin3p6IvpIlR+r+0cjgPWe+L9rt0uX4ut1eBrs6jeZeRhL -->
<!-- /9azI2h15q/6/IvrC4DqaTuv/DDtBEyO3991bWORPdGdVk5Pv4BXIqF4ETIheu9B -->
<!-- CrE/+6jMpF3BoYibV3FWTkhFwELJm3ZbCoBIa/15n8G9bW1qyVJzEw16UM0xghXU -->
<!-- MIIV0AIBATCBlTB+MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ -->
<!-- MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u -->
<!-- MSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQSAyMDExAhMzAAAA -->
<!-- ZEeElIbbQRk4AAAAAABkMA0GCWCGSAFlAwQCAQUAoIHAMBkGCSqGSIb3DQEJAzEM -->
<!-- BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqG -->
<!-- SIb3DQEJBDEiBCB6VOBbVlUopSRQdLZZpPmFZUCdKmiBK+odsLhPqIvmtzBUBgor -->
<!-- BgEEAYI3AgEMMUYwRKAggB4AUwBRAEwAIABTAGUAcgB2AGUAcgAgADIAMAAxADah -->
<!-- IIAeaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3NxbC8gMA0GCSqGSIb3DQEBAQUA -->
<!-- BIIBAF8RLDjiKu49Rwx4UT9EymHeIf3z1kfPwGDmPeatY5g7+Asf4Zw9pYsSRxat -->
<!-- mj0ZugB8J+mkaKjEsR4vXm+cJJAIBPMpZ2Tpl1l1J+eg/mk2Do3JQ6zZnKy2tLfI -->
<!-- fWhbOtqs9qHLYReyIseSJZ1cXCw+bKRW9bAYs/45YGPJVrJvLs9MWB6Krq4cRIYD -->
<!-- fugM2XxkKJRBkVX7lNaQWXciihD9V6aM2WNsnTEVcP73pRtW4zalfvKLylyIugKZ -->
<!-- i4S5tdHl75OWAxEQ6TxkDg2d2WRYjhMrYF3WJZMm47wjNBU7gGJUHhm5R7eDxr5p -->
<!-- lmFvIYlX9ZmJhPHYy5ApZuNZRhWhghNMMIITSAYKKwYBBAGCNwMDATGCEzgwghM0 -->
<!-- BgkqhkiG9w0BBwKgghMlMIITIQIBAzEPMA0GCWCGSAFlAwQCAQUAMIIBPQYLKoZI -->
<!-- hvcNAQkQAQSgggEsBIIBKDCCASQCAQEGCisGAQQBhFkKAwEwMTANBglghkgBZQME -->
<!-- AgEFAAQg6fJpgf2NhtPVbdz6hr1HKf1C/TStyjRUPH7KOhhYNCcCBlchWNcWLRgT -->
<!-- MjAxNjA0MzAxNjAyMzMuODc0WjAHAgEBgAIB9KCBuaSBtjCBszELMAkGA1UEBhMC -->
<!-- VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNV -->
<!-- BAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEnMCUGA1UE -->
<!-- CxMebkNpcGhlciBEU0UgRVNOOjdBRkEtRTQxQy1FMTQyMSUwIwYDVQQDExxNaWNy -->
<!-- b3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNloIIOzzCCBnEwggRZoAMCAQICCmEJgSoA -->
<!-- AAAAAAIwDQYJKoZIhvcNAQELBQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX -->
<!-- YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg -->
<!-- Q29ycG9yYXRpb24xMjAwBgNVBAMTKU1pY3Jvc29mdCBSb290IENlcnRpZmljYXRl -->
<!-- IEF1dGhvcml0eSAyMDEwMB4XDTEwMDcwMTIxMzY1NVoXDTI1MDcwMTIxNDY1NVow -->
<!-- fDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl -->
<!-- ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMd -->
<!-- TWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwggEiMA0GCSqGSIb3DQEBAQUA -->
<!-- A4IBDwAwggEKAoIBAQCpHQ28dxGKOiDs/BOX9fp/aZRrdFQQ1aUKAIKF++18aEss -->
<!-- X8XD5WHCdrc+Zitb8BVTJwQxH0EbGpUdzgkTjnxhMFmxMEQP8WCIhFRDDNdNuDgI -->
<!-- s0Ldk6zWczBXJoKjRQ3Q6vVHgc2/JGAyWGBG8lhHhjKEHnRhZ5FfgVSxz5NMksHE -->
<!-- pl3RYRNuKMYa+YaAu99h/EbBJx0kZxJyGiGKr0tkiVBisV39dx898Fd1rL2KQk1A -->
<!-- UdEPnAY+Z3/1ZsADlkR+79BL/W7lmsqxqPJ6Kgox8NpOBpG2iAg16HgcsOmZzTzn -->
<!-- L0S6p/TcZL2kAcEgCZN4zfy8wMlEXV4WnAEFTyJNAgMBAAGjggHmMIIB4jAQBgkr -->
<!-- BgEEAYI3FQEEAwIBADAdBgNVHQ4EFgQU1WM6XIoxkPNDe3xGG8UzaFqFbVUwGQYJ -->
<!-- KwYBBAGCNxQCBAweCgBTAHUAYgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQF -->
<!-- MAMBAf8wHwYDVR0jBBgwFoAU1fZWy4/oolxiaNE9lJBb186aGMQwVgYDVR0fBE8w -->
<!-- TTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj -->
<!-- dHMvTWljUm9vQ2VyQXV0XzIwMTAtMDYtMjMuY3JsMFoGCCsGAQUFBwEBBE4wTDBK -->
<!-- BggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9N -->
<!-- aWNSb29DZXJBdXRfMjAxMC0wNi0yMy5jcnQwgaAGA1UdIAEB/wSBlTCBkjCBjwYJ -->
<!-- KwYBBAGCNy4DMIGBMD0GCCsGAQUFBwIBFjFodHRwOi8vd3d3Lm1pY3Jvc29mdC5j -->
<!-- b20vUEtJL2RvY3MvQ1BTL2RlZmF1bHQuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwA -->
<!-- ZQBnAGEAbABfAFAAbwBsAGkAYwB5AF8AUwB0AGEAdABlAG0AZQBuAHQALiAdMA0G -->
<!-- CSqGSIb3DQEBCwUAA4ICAQAH5ohRDeLG4Jg/gXEDPZ2joSFvs+umzPUxvs8F4qn+ -->
<!-- +ldtGTCzwsVmyWrf9efweL3HqJ4l4/m87WtUVwgrUYJEEvu5U4zM9GASinbMQEBB -->
<!-- m9xcF/9c+V4XNZgkVkt070IQyK+/f8Z/8jd9Wj8c8pl5SpFSAK84Dxf1L3mBZdmp -->
<!-- tWvkx872ynoAb0swRCQiPM/tA6WWj1kpvLb9BOFwnzJKJ/1Vry/+tuWOM7tiX5rb -->
<!-- V0Dp8c6ZZpCM/2pif93FSguRJuI57BlKcWOdeyFtw5yjojz6f32WapB4pm3S4Zz5 -->
<!-- Hfw42JT0xqUKloakvZ4argRCg7i1gJsiOCC1JeVk7Pf0v35jWSUPei45V3aicaoG -->
<!-- ig+JFrphpxHLmtgOR5qAxdDNp9DvfYPw4TtxCd9ddJgiCGHasFAeb73x4QDf5zEH -->
<!-- pJM692VHeOj4qEir995yfmFrb3epgcunCaw5u+zGy9iCtHLNHfS4hQEegPsbiSpU -->
<!-- ObJb2sgNVZl6h3M7COaYLeqN4DMuEin1wC9UJyH3yKxO2ii4sanblrKnQqLJzxlB -->
<!-- TeCG+SqaoxFmMNO7dDJL32N79ZmKLxvHIa9Zta7cRDyXUHHXodLFVeNp3lfB0d4w -->
<!-- wP3M5k37Db9dT+mdHhk4L7zPWAUu7w2gUDXa7wknHNWzfjUeCLraNtvTX4/edIhJ -->
<!-- EjCCBNowggPCoAMCAQICEzMAAACEk4pCjyx8I+gAAAAAAIQwDQYJKoZIhvcNAQEL -->
<!-- BQAwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT -->
<!-- B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UE -->
<!-- AxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwHhcNMTYwMzMwMTkyNDIz -->
<!-- WhcNMTcwNjMwMTkyNDIzWjCBszELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp -->
<!-- bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw -->
<!-- b3JhdGlvbjENMAsGA1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNO -->
<!-- OjdBRkEtRTQxQy1FMTQyMSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBT -->
<!-- ZXJ2aWNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAy6ZHlFj8Zx6G -->
<!-- NnH3La6YmX9F0jRndeLqbA3ta6WdZ3iuOb116WwA+Pq+reRQn0KR0j4HvlCKIwxE -->
<!-- gX3TZj8Cy+dIGQrw/Qf5IWdxGcm6UX9TLcEQLftFSKWHkWQrJC5cGr7X5NvyXQ80 -->
<!-- RnDrtUpR5KLTATjRjO7Ju/hwxEgxTHphR33hIfBL3FM/dTmrds/Ynb03KCjoPvGv -->
<!-- FDUJjdGAtgUNflsM1/hM9siDW8iuvu1KV/JS2o4//yOn4dFR4TPTlJRhxQREezN+ -->
<!-- 1/i87Hp0a+hzfV/8cBdEr2i+PR/PfOuaT5g9uhGG7OJj85gDFMZH/EJfN2nBz1yN -->
<!-- guaaA0E4cwIDAQABo4IBGzCCARcwHQYDVR0OBBYEFB1UC0cDq5m3oeulSlx2kmAl -->
<!-- dEHbMB8GA1UdIwQYMBaAFNVjOlyKMZDzQ3t8RhvFM2hahW1VMFYGA1UdHwRPME0w -->
<!-- S6BJoEeGRWh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3Rz -->
<!-- L01pY1RpbVN0YVBDQV8yMDEwLTA3LTAxLmNybDBaBggrBgEFBQcBAQROMEwwSgYI -->
<!-- KwYBBQUHMAKGPmh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWlj -->
<!-- VGltU3RhUENBXzIwMTAtMDctMDEuY3J0MAwGA1UdEwEB/wQCMAAwEwYDVR0lBAww -->
<!-- CgYIKwYBBQUHAwgwDQYJKoZIhvcNAQELBQADggEBAIa4dPRdqJeSGYAzaSRPE8iR -->
<!-- mFTym8ehg2olErp66FP1Fn/OZ2YZJACJ1QbCMa1dF2LNOMc2bepdA9f9WEwoUWrZ -->
<!-- Cgq+Lzv5BDoLJ+OJgktzjTaj7ApcMF92Dtfhto90GU1f9Lbbrrv1cU+puWttN9cN -->
<!-- rwAAb26mSSMZzvCFGyV6ZP6CGXARB7uW8XxxZlGyPOkWABHf8I2+ipXH4zLCnJHg -->
<!-- Zi1Hc1bpfOoU3xR0/FwX3yf+7Wzs2GCzUwNMOkju03qa7j+DFAwd5jmwTQqefKO9 -->
<!-- UQxIkJZeTENcmAeH6vAhnxVI7WdwCbtJ8Jj02S4F5fVCYzxlAe57mUMSip6a3zmh -->
<!-- ggN4MIICYAIBATCB46GBuaSBtjCBszELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldh -->
<!-- c2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD -->
<!-- b3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBEU0Ug -->
<!-- RVNOOjdBRkEtRTQxQy1FMTQyMSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFt -->
<!-- cCBTZXJ2aWNloiUKAQEwCQYFKw4DAhoFAAMVAPcrbnOs6Lc4StZGV2RqSRULzDZ9 -->
<!-- oIHCMIG/pIG8MIG5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ -->
<!-- MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u -->
<!-- MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIE5UUyBFU046NERFOS0w -->
<!-- QzVFLTNFMDkxKzApBgNVBAMTIk1pY3Jvc29mdCBUaW1lIFNvdXJjZSBNYXN0ZXIg -->
<!-- Q2xvY2swDQYJKoZIhvcNAQEFBQACBQDazrnYMCIYDzIwMTYwNDMwMDQ1ODAwWhgP -->
<!-- MjAxNjA1MDEwNDU4MDBaMHYwPAYKKwYBBAGEWQoEATEuMCwwCgIFANrOudgCAQAw -->
<!-- CQIBAAIBLwIB/zAHAgEAAgIa7TAKAgUA2tALWAIBADA2BgorBgEEAYRZCgQCMSgw -->
<!-- JjAMBgorBgEEAYRZCgMBoAowCAIBAAIDFuNgoQowCAIBAAIDB6EgMA0GCSqGSIb3 -->
<!-- DQEBBQUAA4IBAQA/QtGbfrwWe42gLi72EPTMHHk9USspEuiAOFPh/+LlNN0JCKtO -->
<!-- TnFAG1Fu1JAQqZ2Mi2q1uyLyOfCeqgl0ye1U3KwlOnyyQVRZFDBbJFQRa21cwLII -->
<!-- pM4yeoFFyeuqYRh+7OTtYyGm0J8iwYt4amJNeIsGUQvNz7tgF1sp4urldGsrLuPB -->
<!-- FTIbgtDkJEg6ZuH1Is5m2yEd+qz4W0et7A77D06fJfazZTzFElZN1LEOdJtnzA3l -->
<!-- pM9wNenZyruy+TjrHQfl4otWeTQxAQ9jb2RM+VFlNXZY43YTuTrOAbSoBhVXTc6Y -->
<!-- LCh2524ESi5XXBqOMnl2UsWpOTbPwog7qVpJMYIC9TCCAvECAQEwgZMwfDELMAkG -->
<!-- A1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx -->
<!-- HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9z -->
<!-- b2Z0IFRpbWUtU3RhbXAgUENBIDIwMTACEzMAAACEk4pCjyx8I+gAAAAAAIQwDQYJ -->
<!-- YIZIAWUDBAIBBQCgggEyMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBDAvBgkq -->
<!-- hkiG9w0BCQQxIgQgd8ERW+AKAZ3Qw7VosJyYMT6nFZisD46I9QOOyeBwq2EwgeIG -->
<!-- CyqGSIb3DQEJEAIMMYHSMIHPMIHMMIGxBBT3K25zrOi3OErWRldkakkVC8w2fTCB -->
<!-- mDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD -->
<!-- VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAk -->
<!-- BgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAhJOKQo8s -->
<!-- fCPoAAAAAACEMBYEFDNUBw3FchcRVuRMFtEufxSotYVPMA0GCSqGSIb3DQEBCwUA -->
<!-- BIIBAEGFY/oq9yXAOLIAb1B9UXt3bCsOryjbRd9V/1bUCdt7c/unG1yNfijljfbw -->
<!-- B4p+d7t7iVfbVuExb828bMVpj6PYXxLxCILsm5g+qhFMcl0ICUtSEirATWJw3epv -->
<!-- qS4yW1JzEZgYEusde+IK8weuFnFLS6+Ce1mGcu50aaxZSzIhrZfKOTH/+IlPr4ur -->
<!-- GFLwrhwU/eEarBSKUd4ZEtYaGn92psRiLTyFycuGKC786JDfsKs4CTWP5dfyaykO -->
<!-- DF9sCcTh6V+JPaUubLS5y3yWAFvraDaw117yUfgRZnPyYIiErXbEGzP1BB1qYbL/ -->
<!-- 4Mp0g6ZQWJh6wAfYILIVLG7xr/c= -->
<!-- SIG # End signature block -->
