/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class WriterOptionBridge {
    private OrcFile.WriterOptions innerOption;
    private Properties properties = new Properties();
    private Configuration conf = new Configuration();
    private ObjectInspector inspector;

    public static WriterOptionBridge create() {
        return new WriterOptionBridge();
    }

    public WriterOptionBridge() {
        this.innerOption = OrcFile.writerOptions((Configuration)this.conf);
    }

    public void columnInfo(String columnNames, String types) {
        this.properties.setProperty("columns", columnNames);
        this.properties.setProperty("columns.types", types);
    }

    public void blockSize(long blockSize) {
        this.innerOption.blockSize(blockSize);
    }

    public void compress(int compressionOrdinal) throws UnsupportedOperationException {
        CompressionKind kind;
        switch (compressionOrdinal) {
            case 0: {
                kind = CompressionKind.NONE;
                break;
            }
            case 1: {
                kind = CompressionKind.ZLIB;
                break;
            }
            case 2: {
                kind = CompressionKind.SNAPPY;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported kind of compression");
            }
        }
        this.innerOption.compress(kind);
    }

    public void blockPadding(boolean isPadding) {
        this.innerOption.blockPadding(isPadding);
    }

    public void rowIndexStride(int stride) {
        this.innerOption.rowIndexStride(stride);
    }

    public void stripeSize(long stripeSize) {
        this.innerOption.stripeSize(stripeSize);
    }

    public void version(int versionOrdinal) throws UnsupportedOperationException {
        OrcFile.Version version;
        switch (versionOrdinal) {
            case 1: {
                version = OrcFile.Version.V_0_11;
                break;
            }
            case 2: {
                version = OrcFile.Version.V_0_12;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported version");
            }
        }
        this.innerOption.version(version);
    }

    ObjectInspector getInspector() throws SerDeException {
        if (this.inspector == null) {
            OrcSerde serde = new OrcSerde();
            serde.initialize(this.conf, this.properties);
            this.inspector = serde.getObjectInspector();
        }
        return this.inspector;
    }

    OrcFile.WriterOptions getOptions() throws SerDeException {
        this.innerOption.inspector(this.getInspector());
        return this.innerOption;
    }
}

