/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import com.microsoft.datatransfer.bridge.io.BridgeFileSystem;
import com.microsoft.datatransfer.bridge.orc.OrcBatchReader;
import com.microsoft.datatransfer.bridge.orc.OrcValueHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class OrcReaderBridge {
    private Reader reader;
    private RecordReader recordReader;
    private Object schemaObject;
    private Object previous;

    public static OrcReaderBridge open(long rawStreamHandle, long fileSize) throws IOException {
        BridgeFileSystem fs = new BridgeFileSystem(rawStreamHandle, fileSize);
        Reader reader = OrcFile.createReader((FileSystem)fs, (Path)new Path(String.valueOf(rawStreamHandle)));
        return new OrcReaderBridge(reader, reader.rows());
    }

    OrcReaderBridge(Reader reader, RecordReader rr) {
        this.reader = reader;
        this.recordReader = rr;
        this.schemaObject = OrcValueHelper.createValue(this.reader.getObjectInspector(), null);
    }

    public boolean hasNext() throws IOException {
        return this.recordReader.hasNext();
    }

    public Object next() throws IOException {
        this.previous = this.recordReader.next(this.previous);
        return OrcValueHelper.createValue(this.reader.getObjectInspector(), this.previous);
    }

    public Object schemaObject() {
        return this.schemaObject;
    }

    public String[] getMetadataKeys() {
        List keyList = this.reader.getMetadataKeys();
        if (keyList == null) {
            return new String[0];
        }
        String[] keys = new String[keyList.size()];
        this.reader.getMetadataKeys().toArray(keys);
        return keys;
    }

    public ByteBuffer getMetadataValue(String key) {
        return this.reader.getMetadataValue(key);
    }

    public int getRootTypeCode() {
        return OrcValueHelper.getTypeCode(this.reader.getObjectInspector());
    }

    public int getRootPrimitiveTypeCode() {
        return OrcValueHelper.getPrimitiveTypeCode(this.reader.getObjectInspector());
    }

    public long numberOfRows() {
        return this.reader.getNumberOfRows();
    }

    public void close() throws IOException {
        this.recordReader.close();
    }

    public OrcBatchReader createBatchReader() throws IOException {
        return new OrcBatchReader(this.recordReader, (StructObjectInspector)this.reader.getObjectInspector());
    }
}

