/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import com.microsoft.datatransfer.bridge.orc.HiveDecimalUtils;
import com.microsoft.datatransfer.bridge.orc.OrcValueHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrcBatchWriter {
    private SettableStructObjectInspector inspector;
    private Writer writer;
    private PrimitiveObjectInspector.PrimitiveCategory[] primitiveTypes;
    private byte[] nullFlags;
    private Writable[] reusableWritables;
    private byte[] bytesCache;

    public Object[] getAllFieldInfo() {
        return this.inspector.getAllStructFieldRefs().toArray();
    }

    public StructField getFieldInfo(String name) {
        return this.inspector.getStructFieldRef(name);
    }

    public int getPrimitiveTypeCode(StructField field) {
        return OrcValueHelper.getPrimitiveTypeCode(field.getFieldObjectInspector());
    }

    public String getFieldName(StructField field) {
        return field.getFieldName();
    }

    public OrcBatchWriter(Writer writer, SettableStructObjectInspector inspector) {
        this.inspector = inspector;
        this.writer = writer;
        List fields = inspector.getAllStructFieldRefs();
        int colSize = fields.size();
        this.primitiveTypes = new PrimitiveObjectInspector.PrimitiveCategory[colSize];
        this.reusableWritables = new Writable[colSize];
        for (int i = 0; i < colSize; ++i) {
            ObjectInspector fieldInspector = ((StructField)fields.get(i)).getFieldObjectInspector();
            if (fieldInspector.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UnsupportedOperationException("Rows contain complex types cannot use batch write");
            }
            this.primitiveTypes[i] = ((PrimitiveObjectInspector)fieldInspector).getPrimitiveCategory();
            Writable writable = OrcBatchWriter.createWritableForType(this.primitiveTypes[i]);
            if (writable == null) {
                throw new UnsupportedOperationException("Column:" + i + " have unsupported types:" + this.primitiveTypes[i]);
            }
            this.reusableWritables[i] = writable;
        }
        this.nullFlags = new byte[fields.size()];
        this.bytesCache = new byte[4096];
    }

    public final void addRows(ByteBuffer rowsBuf) throws IOException {
        Object rowStruct = this.inspector.create();
        List fields = this.inspector.getAllStructFieldRefs();
        while (rowsBuf.remaining() > 0) {
            this.readRow(rowsBuf, rowStruct, fields);
            this.writer.addRow(rowStruct);
        }
    }

    ByteBuffer allocateNativeOrderBuffer(int capacity) {
        ByteBuffer ret = ByteBuffer.allocateDirect(capacity);
        ret.order(ByteOrder.nativeOrder());
        return ret;
    }

    private byte[] getBytesCache(int minCap) {
        if (minCap > this.bytesCache.length) {
            this.bytesCache = new byte[minCap];
        }
        return this.bytesCache;
    }

    private static Writable createWritableForType(PrimitiveObjectInspector.PrimitiveCategory primeType) {
        switch (primeType) {
            case BINARY: {
                return new BytesWritable();
            }
            case BOOLEAN: {
                return new BooleanWritable();
            }
            case BYTE: {
                return new ByteWritable();
            }
            case CHAR: 
            case STRING: 
            case VARCHAR: {
                return new Text();
            }
            case DATE: {
                return new DateWritable();
            }
            case DECIMAL: {
                return new HiveDecimalWritable();
            }
            case DOUBLE: {
                return new DoubleWritable();
            }
            case FLOAT: {
                return new FloatWritable();
            }
            case INT: {
                return new IntWritable();
            }
            case LONG: {
                return new LongWritable();
            }
            case SHORT: {
                return new ShortWritable();
            }
            case TIMESTAMP: {
                return new TimestampWritable();
            }
        }
        return null;
    }

    private void readRow(ByteBuffer rowsBuf, Object rowStruct, List<? extends StructField> fields) {
        PrimitiveObjectInspector.PrimitiveCategory[] types = this.primitiveTypes;
        rowsBuf.get(this.nullFlags);
        block14: for (int i = 0; i < types.length; ++i) {
            if (this.nullFlags[i] == 0) {
                this.inspector.setStructFieldData(rowStruct, fields.get(i), null);
                continue;
            }
            Writable reusableWritable = this.reusableWritables[i];
            switch (types[i]) {
                case BINARY: {
                    int len = rowsBuf.getInt();
                    BytesWritable bytesWritable = (BytesWritable)reusableWritable;
                    bytesWritable.setSize(len);
                    rowsBuf.get(bytesWritable.getBytes(), 0, len);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)bytesWritable);
                    continue block14;
                }
                case BOOLEAN: {
                    boolean val = rowsBuf.get() != 0;
                    ((BooleanWritable)reusableWritable).set(val);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                case BYTE: {
                    byte val = rowsBuf.get();
                    ((ByteWritable)reusableWritable).set(val);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                case CHAR: 
                case STRING: 
                case VARCHAR: {
                    int len = rowsBuf.getInt();
                    Text txt = (Text)reusableWritable;
                    byte[] utf8 = this.getBytesCache(len);
                    rowsBuf.get(utf8, 0, len);
                    txt.set(utf8, 0, len);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)txt);
                    continue block14;
                }
                case DATE: {
                    long millis = rowsBuf.getLong();
                    ((DateWritable)reusableWritable).set(new Date(millis));
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                case DECIMAL: {
                    int len = rowsBuf.getInt();
                    HiveDecimal decimal = HiveDecimalUtils.deserializeHiveDecimal(rowsBuf, len);
                    ((HiveDecimalWritable)reusableWritable).set(decimal);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                case DOUBLE: {
                    double val = rowsBuf.getDouble();
                    ((DoubleWritable)reusableWritable).set(val);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                case FLOAT: {
                    float val = rowsBuf.getFloat();
                    ((FloatWritable)reusableWritable).set(val);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                case INT: {
                    int val = rowsBuf.getInt();
                    ((IntWritable)reusableWritable).set(val);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                case LONG: {
                    long val = rowsBuf.getLong();
                    ((LongWritable)reusableWritable).set(val);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                case SHORT: {
                    short val = rowsBuf.getShort();
                    ((ShortWritable)reusableWritable).set(val);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                case TIMESTAMP: {
                    long val = rowsBuf.getLong();
                    int nanos = rowsBuf.getInt();
                    Timestamp ts = new Timestamp(val);
                    ts.setNanos(nanos);
                    ((TimestampWritable)reusableWritable).set(ts);
                    this.inspector.setStructFieldData(rowStruct, fields.get(i), (Object)reusableWritable);
                    continue block14;
                }
                default: {
                    throw new UnsupportedOperationException("Column:" + i + " have unsupported types:" + types[i]);
                }
            }
        }
    }
}

