/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import com.microsoft.datatransfer.bridge.orc.HiveDecimalUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrcBatchReader {
    private RecordReader reader;
    private StructObjectInspector inspector;
    private PrimitiveObjectInspector.PrimitiveCategory[] primitiveTypes;
    private ByteBuffer rowsBuffer;
    private int fixedRowLength;
    private int[] dynamicLengthRowIndices;
    private byte[] nullFlags;
    private OrcStruct lastRow;

    public OrcBatchReader(RecordReader reader, StructObjectInspector inspector) throws IOException {
        this.reader = reader;
        this.inspector = inspector;
        this.initWithColumnInfo(inspector.getAllStructFieldRefs());
        this.rowsBuffer = ByteBuffer.allocateDirect(0x400000);
        this.rowsBuffer.order(ByteOrder.nativeOrder());
    }

    public byte[] getPrimitiveTypeValues() {
        byte[] ret = new byte[this.primitiveTypes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)this.primitiveTypes[i].ordinal();
        }
        return ret;
    }

    public boolean hasNext() throws IOException {
        return this.lastRow != null || this.reader.hasNext();
    }

    public ByteBuffer nextBuffer() throws IOException {
        int estimatedLen;
        List values;
        this.rowsBuffer.clear();
        if (this.lastRow != null) {
            values = this.inspector.getStructFieldsDataAsList((Object)this.lastRow);
            estimatedLen = this.getEstimatedLength(values);
            this.ensureBuffer(estimatedLen);
            this.fillRow(values);
        }
        while (this.reader.hasNext()) {
            this.lastRow = (OrcStruct)this.reader.next((Object)this.lastRow);
            values = this.inspector.getStructFieldsDataAsList((Object)this.lastRow);
            estimatedLen = this.getEstimatedLength(values);
            if (estimatedLen > this.rowsBuffer.remaining()) {
                this.rowsBuffer.flip();
                return this.rowsBuffer;
            }
            this.fillRow(values);
        }
        this.lastRow = null;
        this.rowsBuffer.flip();
        return this.rowsBuffer;
    }

    private void ensureBuffer(int len) {
        if (len > this.rowsBuffer.capacity()) {
            this.rowsBuffer = ByteBuffer.allocateDirect(len);
            this.rowsBuffer.order(ByteOrder.nativeOrder());
        }
    }

    private void initWithColumnInfo(List<? extends StructField> fields) {
        int i;
        this.primitiveTypes = new PrimitiveObjectInspector.PrimitiveCategory[fields.size()];
        this.nullFlags = new byte[fields.size()];
        this.fixedRowLength = 0;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (i = 0; i < fields.size(); ++i) {
            PrimitiveObjectInspector.PrimitiveCategory type;
            StructField field = fields.get(i);
            ObjectInspector fieldInspector = field.getFieldObjectInspector();
            if (fieldInspector.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UnsupportedOperationException("Rows contain complex types cannot use batch read.");
            }
            this.primitiveTypes[i] = type = ((PrimitiveObjectInspector)fieldInspector).getPrimitiveCategory();
            int fixed = this.getFixedLengthOfType(type);
            if (fixed > 0) {
                this.fixedRowLength += fixed;
                continue;
            }
            indices.add(i);
        }
        this.dynamicLengthRowIndices = new int[indices.size()];
        for (i = 0; i < this.dynamicLengthRowIndices.length; ++i) {
            this.dynamicLengthRowIndices[i] = (Integer)indices.get(i);
        }
    }

    private int getFixedLengthOfType(PrimitiveObjectInspector.PrimitiveCategory type) {
        switch (type) {
            case BINARY: 
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                return 0;
            }
            case BOOLEAN: 
            case BYTE: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case FLOAT: 
            case INT: {
                return 4;
            }
            case DATE: 
            case DOUBLE: 
            case LONG: {
                return 8;
            }
            case TIMESTAMP: {
                return 12;
            }
            case DECIMAL: {
                return 20;
            }
        }
        throw new UnsupportedOperationException("Rows contain type:" + type + " cannot use batch read.");
    }

    private int getEstimatedLength(List<Object> values) {
        int len = values.size();
        for (int i = 0; i < this.dynamicLengthRowIndices.length; ++i) {
            Object val = values.get(this.dynamicLengthRowIndices[i]);
            if (!(val instanceof BinaryComparable)) continue;
            len += 4 + ((BinaryComparable)val).getLength();
        }
        return len + this.fixedRowLength;
    }

    private void setNullFlags(List<Object> values) {
        for (int i = 0; i < values.size(); ++i) {
            this.nullFlags[i] = values.get(i) == null ? (byte)0 : 1;
        }
    }

    private void fillRow(List<Object> values) {
        this.setNullFlags(values);
        this.rowsBuffer.put(this.nullFlags);
        block14: for (int i = 0; i < this.primitiveTypes.length; ++i) {
            PrimitiveObjectInspector.PrimitiveCategory type = this.primitiveTypes[i];
            Object val = values.get(i);
            if (val == null) continue;
            switch (type) {
                case BINARY: {
                    BytesWritable bytesWritable = (BytesWritable)val;
                    this.rowsBuffer.putInt(bytesWritable.getLength());
                    this.rowsBuffer.put(bytesWritable.getBytes(), 0, bytesWritable.getLength());
                    continue block14;
                }
                case CHAR: 
                case VARCHAR: 
                case STRING: {
                    Text txt = (Text)val;
                    this.rowsBuffer.putInt(txt.getLength());
                    this.rowsBuffer.put(txt.getBytes(), 0, txt.getLength());
                    continue block14;
                }
                case BOOLEAN: {
                    this.rowsBuffer.put(((BooleanWritable)val).get() ? (byte)1 : 0);
                    continue block14;
                }
                case BYTE: {
                    this.rowsBuffer.put(((ByteWritable)val).get());
                    continue block14;
                }
                case DATE: {
                    this.rowsBuffer.putLong(((DateWritable)val).get().getTime());
                    continue block14;
                }
                case DECIMAL: {
                    this.rowsBuffer.putInt(16);
                    HiveDecimal decimal = ((HiveDecimalWritable)val).getHiveDecimal();
                    HiveDecimalUtils.serializeDecimal128(decimal, this.rowsBuffer);
                    continue block14;
                }
                case DOUBLE: {
                    this.rowsBuffer.putDouble(((DoubleWritable)val).get());
                    continue block14;
                }
                case FLOAT: {
                    this.rowsBuffer.putFloat(((FloatWritable)val).get());
                    continue block14;
                }
                case INT: {
                    this.rowsBuffer.putInt(((IntWritable)val).get());
                    continue block14;
                }
                case LONG: {
                    this.rowsBuffer.putLong(((LongWritable)val).get());
                    continue block14;
                }
                case SHORT: {
                    this.rowsBuffer.putShort(((ShortWritable)val).get());
                    continue block14;
                }
                case TIMESTAMP: {
                    Timestamp ts = ((TimestampWritable)val).getTimestamp();
                    long millis = ts.getTime();
                    int nanos = ts.getNanos();
                    if (millis < 0L && nanos > 0) {
                        millis -= 1000L;
                    }
                    millis = millis / 1000L * 1000L;
                    this.rowsBuffer.putLong(millis);
                    this.rowsBuffer.putInt(nanos);
                    continue block14;
                }
            }
        }
    }
}

