/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveDecimal;

public class HiveDecimalUtils {
    public static ByteBuffer sharedBuffer = ByteBuffer.allocateDirect(1024);
    private static final BigInteger max96BitsUnscaleValue;
    private static final int decimal128UnscaleDataLength = 12;
    private static final int decimal128MaxPrecision = 28;

    public static void serializeDecimal128(HiveDecimal decimal, ByteBuffer outBuffer) {
        int offset;
        int precision;
        BigInteger unscale = decimal.unscaledValue().abs();
        int n = precision = unscale.compareTo(max96BitsUnscaleValue) <= 0 ? 29 : 28;
        if (decimal.precision() - decimal.scale() > precision) {
            throw new ArithmeticException("Decimal overflow,value:" + decimal);
        }
        BigDecimal bd = decimal.bigDecimalValue().round(new MathContext(precision, RoundingMode.HALF_UP));
        if (bd.scale() < 0) {
            bd = bd.setScale(0, RoundingMode.HALF_UP);
        }
        int restBits = bd.signum() << 24 | bd.scale();
        byte[] restBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            restBytes[i] = (byte)(restBits >> (3 - i) * 8);
        }
        outBuffer.put(restBytes);
        byte[] bytes = unscale.toByteArray();
        int copyLength = 12;
        for (offset = bytes.length - 12; offset < 0; ++offset) {
            outBuffer.put((byte)0);
            --copyLength;
        }
        outBuffer.put(bytes, offset, copyLength);
    }

    @Deprecated
    public static void serializeHiveDecimal(HiveDecimal decimal, int maxPrecision, int minScale, ByteBuffer outBuffer) {
        if (decimal.precision() - decimal.scale() > maxPrecision - minScale) {
            throw new ArithmeticException("Decimal overflow,value:" + decimal);
        }
        BigDecimal bd = decimal.bigDecimalValue().round(new MathContext(maxPrecision, RoundingMode.HALF_UP));
        if (bd.scale() < minScale) {
            bd = bd.setScale(minScale, RoundingMode.HALF_UP);
        }
        int restBits = bd.signum() << 24 | bd.scale();
        byte[] restBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            restBytes[i] = (byte)(restBits >> (3 - i) * 8);
        }
        outBuffer.put(restBytes);
        byte[] bytes = bd.unscaledValue().abs().toByteArray();
        outBuffer.put(bytes, bytes.length - 12, 12);
    }

    public static void serializeHiveDecimalExact(HiveDecimal decimal, ByteBuffer outBuffer) {
        int restBits = decimal.signum() << 24 | decimal.scale();
        byte[] restBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            restBytes[i] = (byte)(restBits >> (3 - i) * 8);
        }
        outBuffer.put(restBytes);
        outBuffer.put(decimal.unscaledValue().toByteArray());
    }

    public static HiveDecimal deserializeHiveDecimal(ByteBuffer inBuffer, int len) {
        byte[] flagBytes = new byte[4];
        inBuffer.get(flagBytes);
        int restBits = flagBytes[0] << 24 | flagBytes[1] << 16 | flagBytes[2] << 8 | flagBytes[3];
        byte[] unscaledBytes = new byte[len - 4];
        inBuffer.get(unscaledBytes);
        return HiveDecimal.create((BigInteger)new BigInteger((int)((byte)(restBits >> 24 & 0xFF)), unscaledBytes), (int)(restBits & 0xFFFFFF));
    }

    public static HiveDecimal deserializeHiveDecimal(ByteBuffer inBuffer) {
        return HiveDecimalUtils.deserializeHiveDecimal(inBuffer, inBuffer.remaining());
    }

    static {
        byte[] unscale = new byte[12];
        Arrays.fill(unscale, (byte)-1);
        unscale[0] = 127;
        max96BitsUnscaleValue = new BigInteger(unscale);
    }
}

