/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.orc;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ColumnPropertiesBuilder {
    private List<String> names = new ArrayList<String>();
    private List<String> types = new ArrayList<String>();

    public final ColumnPropertiesBuilder column(String name, String columnType) {
        this.names.add(name);
        this.types.add(columnType);
        return this;
    }

    public final ColumnPropertiesBuilder column(String columnType) {
        this.names.add("col-" + this.names.size());
        this.types.add(columnType);
        return this;
    }

    public Properties build() {
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnTypes = new StringBuilder();
        for (int i = 0; i < this.names.size(); ++i) {
            if (i > 0) {
                columnNames.append(",");
                columnTypes.append(",");
            }
            columnNames.append(this.names.get(i));
            columnTypes.append(this.types.get(i));
        }
        Properties retProps = new Properties();
        retProps.setProperty("columns", columnNames.toString());
        retProps.setProperty("columns.types", columnTypes.toString());
        return retProps;
    }
}

