/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge.io;

import com.microsoft.datatransfer.bridge.io.IoBridge;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class BridgeOutputStream
extends OutputStream {
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 0x400000;
    private final ByteBuffer internalBuffer;
    private long dotnetHandle;

    public BridgeOutputStream(long rawStreamHandle) throws IOException {
        this.dotnetHandle = IoBridge.outputStreamCreate(rawStreamHandle);
        if (this.dotnetHandle == 0L) {
            throw new IOException("Cannot open dotnet resource");
        }
        this.internalBuffer = ByteBuffer.allocateDirect(0x400000);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (!this.internalBuffer.hasRemaining()) {
                this.flush();
            }
            int writeLen = Math.min(this.internalBuffer.remaining(), len);
            this.internalBuffer.put(b, off, writeLen);
            off += writeLen;
            len -= writeLen;
        }
    }

    public void flush() throws IOException {
        if (this.dotnetHandle == 0L) {
            throw new IOException("Stream is closed.");
        }
        this.internalBuffer.flip();
        if (this.internalBuffer.hasRemaining()) {
            IoBridge.outputStreamWrite(this.dotnetHandle, this.internalBuffer);
            IoBridge.outputStreamFlush(this.dotnetHandle);
        }
        this.internalBuffer.clear();
    }

    public void write(int b) throws IOException {
        if (!this.internalBuffer.hasRemaining()) {
            this.flush();
        }
        this.internalBuffer.put((byte)b);
    }

    public void close() throws IOException {
        if (this.dotnetHandle == 0L) {
            return;
        }
        try {
            this.flush();
            IoBridge.outputStreamClose(this.dotnetHandle);
        }
        finally {
            IoBridge.outputStreamDestroy(this.dotnetHandle);
            this.dotnetHandle = 0L;
        }
    }

    protected void finalize() throws Throwable {
        IoBridge.outputStreamDestroy(this.dotnetHandle);
        super.finalize();
    }
}

