/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.datatransfer.bridge;

public class ThrowableUtils {
    public static String getMessage(Throwable t) {
        return t.getMessage();
    }

    public static String getStackTrace(Throwable t) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] traces = t.getStackTrace();
        sb.append("total entry:").append(traces.length).append(System.lineSeparator());
        for (StackTraceElement ele : traces) {
            sb.append(ele.toString());
            sb.append(System.lineSeparator());
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            sb.append(cause.getClass().getName());
            sb.append(":");
            sb.append(cause.getMessage());
            sb.append(System.lineSeparator());
            sb.append(ThrowableUtils.getStackTrace(cause));
        }
        return sb.toString();
    }

    public static String getExceptionName(Throwable t) {
        return t.getClass().getName();
    }
}

