/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;

public class VectorMapJoinOuterMultiKeyOperator
extends VectorMapJoinOuterGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinOuterMultiKeyOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinOuterMultiKeyOperator.class.getName();
    private transient VectorMapJoinBytesHashMap hashMap;
    private transient VectorSerializeRow keyVectorSerializeWrite;
    private transient ByteStream.Output currentKeyOutput;
    private transient ByteStream.Output saveKeyOutput;

    public VectorMapJoinOuterMultiKeyOperator() {
    }

    public VectorMapJoinOuterMultiKeyOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            boolean allKeyInputColumnsRepeating;
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.keyVectorSerializeWrite = new VectorSerializeRow(new BinarySortableSerializeWrite(this.bigTableKeyColumnMap.length));
                this.keyVectorSerializeWrite.init(this.bigTableKeyTypeNames, this.bigTableKeyColumnMap);
                this.currentKeyOutput = new ByteStream.Output();
                this.saveKeyOutput = new ByteStream.Output();
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMap = (VectorMapJoinBytesHashMap)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            this.outerPerBatchSetup(batch);
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            int numSel = 0;
            boolean someKeyInputColumnIsNull = false;
            if (this.bigTableKeyColumnMap.length == 0) {
                allKeyInputColumnsRepeating = false;
            } else {
                allKeyInputColumnsRepeating = true;
                for (int i = 0; i < this.bigTableKeyColumnMap.length; ++i) {
                    ColumnVector colVector = batch.cols[this.bigTableKeyColumnMap[i]];
                    if (!colVector.isRepeating) {
                        allKeyInputColumnsRepeating = false;
                        break;
                    }
                    if (colVector.noNulls || !colVector.isNull[0]) continue;
                    someKeyInputColumnIsNull = true;
                }
            }
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                if (someKeyInputColumnIsNull) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else {
                    this.keyVectorSerializeWrite.setOutput(this.currentKeyOutput);
                    this.keyVectorSerializeWrite.serializeWrite(batch, 0);
                    byte[] keyBytes = this.currentKeyOutput.getData();
                    int keyLength = this.currentKeyOutput.getLength();
                    joinResult = this.hashMap.lookup(keyBytes, 0, keyLength, this.hashMapResults[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name()));
                }
                numSel = this.finishOuterRepeated(batch, joinResult, this.hashMapResults[0], this.scratch1);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated"));
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMapResultCount = 0;
                int matchCount = 0;
                int nonSpillCount = 0;
                int spillCount = 0;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block16: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    this.keyVectorSerializeWrite.setOutput(this.currentKeyOutput);
                    boolean isNull = this.keyVectorSerializeWrite.serializeWrite(batch, batchIndex);
                    if (isNull) {
                        this.nonSpills[nonSpillCount++] = batchIndex;
                        continue;
                    }
                    if (!haveSaveKey || !this.saveKeyOutput.arraysEquals(this.currentKeyOutput)) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: 
                                case SPILL: {
                                    ++hashMapResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        ByteStream.Output temp = this.saveKeyOutput;
                        this.saveKeyOutput = this.currentKeyOutput;
                        this.currentKeyOutput = temp;
                        byte[] keyBytes = this.saveKeyOutput.getData();
                        int keyLength = this.saveKeyOutput.getLength();
                        saveJoinResult = this.hashMap.lookup(keyBytes, 0, keyLength, this.hashMapResults[hashMapResultCount]);
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            this.matchs[matchCount] = batchIndex;
                            this.matchHashMapResultIndices[matchCount] = hashMapResultCount;
                            ++matchCount;
                            this.nonSpills[nonSpillCount++] = batchIndex;
                            continue block16;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                            ++spillCount;
                            continue block16;
                        }
                        case NOMATCH: {
                            this.nonSpills[nonSpillCount++] = batchIndex;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: 
                        case SPILL: {
                            ++hashMapResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " matchs " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.matchs, matchCount) + " matchHashMapResultIndices " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.matchHashMapResultIndices, matchCount) + " nonSpills " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.nonSpills, nonSpillCount) + " spills " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinOuterMultiKeyOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMapResults, 0, hashMapResultCount))));
                }
                numSel = this.finishOuter(batch, this.matchs, this.matchHashMapResultIndices, matchCount, this.nonSpills, nonSpillCount, this.spills, this.spillHashMapResultIndices, spillCount, this.hashMapResults, hashMapResultCount, this.scratch1);
            }
            batch.selectedInUse = true;
            batch.size = numSel;
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

