/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public abstract class VectorMapJoinInnerBigOnlyGenerateResultOperator
extends VectorMapJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinInnerBigOnlyGenerateResultOperator.class.getName());
    protected transient VectorMapJoinHashMultiSetResult[] hashMultiSetResults;
    protected transient int[] allMatchs;
    protected transient long[] equalKeySeriesValueCounts;
    protected transient int[] equalKeySeriesAllMatchIndices;
    protected transient int[] equalKeySeriesDuplicateCounts;
    protected transient int[] spills;
    protected transient int[] spillHashMapResultIndices;

    public VectorMapJoinInnerBigOnlyGenerateResultOperator() {
    }

    public VectorMapJoinInnerBigOnlyGenerateResultOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    protected void commonSetup(VectorizedRowBatch batch) throws HiveException {
        super.commonSetup(batch);
        VectorMapJoinHashMultiSet baseHashMultiSet = (VectorMapJoinHashMultiSet)this.vectorMapJoinHashTable;
        this.hashMultiSetResults = new VectorMapJoinHashMultiSetResult[1024];
        for (int i = 0; i < this.hashMultiSetResults.length; ++i) {
            this.hashMultiSetResults[i] = baseHashMultiSet.createHashMultiSetResult();
        }
        this.allMatchs = new int[1024];
        this.equalKeySeriesValueCounts = new long[1024];
        this.equalKeySeriesAllMatchIndices = new int[1024];
        this.equalKeySeriesDuplicateCounts = new int[1024];
        this.spills = new int[1024];
        this.spillHashMapResultIndices = new int[1024];
    }

    protected int finishInnerBigOnly(VectorizedRowBatch batch, int[] allMatchs, int allMatchCount, long[] equalKeySeriesValueCounts, int[] equalKeySeriesAllMatchIndices, int[] equalKeySeriesDuplicateCounts, int equalKeySeriesCount, int[] spills, int[] spillHashMapResultIndices, int spillCount, VectorMapJoinHashTableResult[] hashTableResults, int hashMapResultCount) throws HiveException, IOException {
        int numSel = 0;
        if (allMatchCount > 0 && this.bigTableValueExpressions != null) {
            this.performValueExpressions(batch, allMatchs, allMatchCount);
        }
        for (int i = 0; i < equalKeySeriesCount; ++i) {
            long count = equalKeySeriesValueCounts[i];
            int allMatchesIndex = equalKeySeriesAllMatchIndices[i];
            int duplicateCount = equalKeySeriesDuplicateCounts[i];
            if (count == 1L) {
                numSel = this.generateHashMultiSetResultSingleValue(batch, allMatchs, allMatchesIndex, duplicateCount, numSel);
                continue;
            }
            this.generateHashMultiSetResultMultiValue(batch, allMatchs, allMatchesIndex, duplicateCount, count);
        }
        if (spillCount > 0) {
            this.spillHashMapBatch(batch, hashTableResults, spills, spillHashMapResultIndices, spillCount);
        }
        return numSel;
    }

    private int generateHashMultiSetResultSingleValue(VectorizedRowBatch batch, int[] allMatchs, int allMatchesIndex, int duplicateCount, int numSel) throws HiveException, IOException {
        for (int i = 0; i < duplicateCount; ++i) {
            int batchIndex = allMatchs[allMatchesIndex + i];
            batch.selected[numSel++] = batchIndex;
        }
        return numSel;
    }

    private void generateHashMultiSetResultMultiValue(VectorizedRowBatch batch, int[] allMatchs, int allMatchesIndex, int duplicateCount, long count) throws HiveException, IOException {
        for (int i = 0; i < duplicateCount; ++i) {
            int batchIndex = allMatchs[allMatchesIndex + i];
            for (long l = 0L; l < count; ++l) {
                if (this.bigTableRetainedVectorCopy != null) {
                    this.bigTableRetainedVectorCopy.copyByValue(batch, batchIndex, this.overflowBatch, this.overflowBatch.size);
                }
                ++this.overflowBatch.size;
                if (this.overflowBatch.size != 1024) continue;
                this.forwardOverflow();
            }
        }
    }

    protected int generateHashMultiSetResultRepeatedAll(VectorizedRowBatch batch, VectorMapJoinHashMultiSetResult hashMultiSetResult) throws HiveException {
        long count = hashMultiSetResult.count();
        if (!batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int i = 0; i < batch.size; ++i) {
                selected[i] = i;
            }
            batch.selectedInUse = true;
        }
        do {
            this.forwardBigTableBatch(batch);
        } while (--count > 0L);
        return 0;
    }

    protected int finishInnerBigOnlyRepeated(VectorizedRowBatch batch, JoinUtil.JoinResult joinResult, VectorMapJoinHashMultiSetResult hashMultiSetResult) throws HiveException, IOException {
        int numSel = 0;
        switch (joinResult) {
            case MATCH: {
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                numSel = this.generateHashMultiSetResultRepeatedAll(batch, hashMultiSetResult);
                break;
            }
            case SPILL: {
                this.spillBatchRepeated(batch, hashMultiSetResult);
                break;
            }
        }
        return numSel;
    }
}

