/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2020 - 2021 Intel Corporation */
#ifndef UBUNTU_KCOMPAT_H
#define UBUNTU_KCOMPAT_H

/* Ubuntu 20.04 */

/* Ubuntu 20.04 backport from > 5.4 kernel */
#define IB_UMEM_GET_V2
#define RDMA_MMAP_DB_SUPPORT
/* end of Ubuntu 20.04 backport */

#define CREATE_AH_VER_2
#define DESTROY_AH_VER_3
#define ALLOC_UCONTEXT_VER_2
#define DEALLOC_UCONTEXT_VER_2
#define ALLOC_PD_VER_3
#define DEALLOC_PD_VER_3
#define SET_ROCE_CM_INFO_VER_3

#define HAS_IB_SET_DEVICE_OP
#define NETDEV_TO_IBDEV_SUPPORT
#define IB_DEALLOC_DRIVER_SUPPORT
#define IRDMA_DEVLINK_RELOAD_SPLIT_OPS
#define DEVLINK_RELOAD_DOWN_VER_1
#define IB_IW_PKEY
#define DEVLINK_RELOAD_UP_VER_1
#define IRDMA_ALLOC_MW_VER_1
#define IRDMA_DESTROY_CQ_VER_3

#define ah_attr_to_dmac(attr) ((attr).roce.dmac)
#define set_ibdev_dma_device(ibdev, dev)
#define set_max_sge(props, rf)  do {    \
	((props)->max_send_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags); \
	((props)->max_recv_sge = (rf)->sc_dev.hw_attrs.uk_attrs.max_hw_wq_frags); \
	} while (0)

#define kc_deref_sgid_attr(sgid_attr) ((sgid_attr)->ndev)
#define kc_destroy_qp(ibqp, udata) irdma_destroy_qp(ibqp, udata)
#define kc_get_ucontext(udata) rdma_udata_to_drv_context(udata, struct irdma_ucontext, ibucontext)
#define kc_ib_modify_qp_is_ok(cur_state, next_state, type, mask, ll) ib_modify_qp_is_ok(cur_state, next_state, type, mask)
#define kc_ib_register_device(device, name, dev) ib_register_device(device, name)
#define kc_rdma_gid_attr_network_type(sgid_attr, gid_type, gid)  rdma_gid_attr_network_type(sgid_attr)
#define kc_rdma_udata_to_drv_context(ibpd, udata) rdma_udata_to_drv_context(udata, struct irdma_ucontext, ibucontext)
#define kc_set_ibdev_add_del_gid(ibdev)
#define kc_set_props_ip_gid_caps(props)	((props)->ip_gids = true)
#define kc_typeq_ib_wr const

int irdma_alloc_ucontext(struct ib_ucontext *uctx, struct ib_udata *udata);
int irdma_alloc_pd(struct ib_pd *pd, struct ib_udata *udata);
void irdma_dealloc_ucontext(struct ib_ucontext *context);
void irdma_dealloc_pd(struct ib_pd *ibpd, struct ib_udata *udata);

#endif /* UBUNTU_KCOMPAT_H */
